<?php

namespace App\Entities\Lecturers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booking extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('appointment', 'confirmed');

    public function lecturer()
    {
        return $this->belongsTo('Lecturer');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}